using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    public struct Point : IComparable<Point>
    {
        public long X, Y;

        public Point(long x, long y)
        {
            X = x;
            Y = y;
        }

        public int CompareTo(Point other)
        {
            if (X == other.X) return Y.CompareTo(other.Y);
            return X.CompareTo(other.X);
        }
    }

    static long Cross(Point o, Point a, Point b)
    {
        return (a.X - o.X) * (b.Y - o.Y) - (a.Y - o.Y) * (b.X - o.X);
    }

    static List<Point> KonveksniOmotac(List<Point> tacke)
    {
        tacke.Sort();

        List<Point> nizi = new List<Point>();
        foreach (var p in tacke)
        {
            while (nizi.Count >= 2 && Cross(nizi[nizi.Count - 2], nizi[nizi.Count - 1], p) <= 0)
                nizi.RemoveAt(nizi.Count - 1);
            nizi.Add(p);
        }

        List<Point> visi = new List<Point>();
        for (int i = tacke.Count - 1; i >= 0; i--)
        {
            var p = tacke[i];
            while (visi.Count >= 2 && Cross(visi[visi.Count - 2], visi[visi.Count - 1], p) <= 0)
                visi.RemoveAt(visi.Count - 1);
            visi.Add(p);
        }

        nizi.RemoveAt(nizi.Count - 1);
        visi.RemoveAt(visi.Count - 1);
        nizi.AddRange(visi);

        return nizi;
    }

    static long PovrsinaPoligona(List<Point> polygon)
    {
        long povrsina = 0;
        int n = polygon.Count;
        for (int i = 0; i < n; i++)
        {
            Point p1 = polygon[i];
            Point p2 = polygon[(i + 1) % n];
            povrsina += p1.X * p2.Y - p1.Y * p2.X;
        }
        return Math.Abs(povrsina) / 2;
    }

    static long SkoroPovrsinaKonveksnogOmotaca(List<Point> tacke)
    {
        int n = tacke.Count;
        List<Point> originalniOmotac = KonveksniOmotac(tacke);
        long minPovrsina = long.MaxValue;

        for (int i = 0; i < n; i++)
        {
            var smanjeneTacke = new List<Point>(tacke);
            smanjeneTacke.RemoveAt(i);

            List<Point> omotac = KonveksniOmotac(smanjeneTacke);
            long povrsina = PovrsinaPoligona(omotac);
            minPovrsina = Math.Min(minPovrsina, povrsina);
        }

        return minPovrsina;
    }

    static void Main(string[] args)
    {
        int n = int.Parse(Console.ReadLine());
        List<Point> tacke = new List<Point>();

        for (int i = 0; i < n; i++)
        {
            var input = Console.ReadLine().Split();
            long x = long.Parse(input[0]);
            long y = long.Parse(input[1]);
            tacke.Add(new Point(x, y));
        }

        long rezultat = SkoroPovrsinaKonveksnogOmotaca(tacke);
        Console.WriteLine(rezultat);
    }
}